% Low Rank Tensor Completion

clear; clc
rng('default')
n  = 50;
n1 = n;
n2 = n;
n3 = n;
r  = 5; % tensor average rank
L  = dct(eye(n3));
M  = tproduct(randn(n1,r,n3),randn(r,n2,n3),L);

p              = 0.5;
List           = rand(n1*n2*n3,1);
omega          = find(List<p);
Omega          = zeros(n1,n2,n3);
Iones          = ones(n1,n2,n3);
Omega(omega)   = Iones(omega);
Data           = Omega.*M;

opts.maxiter   = 3000;
opts.lambdamax = 1e+6;
opts.lambdamin = 1;

opts.mu        = 0.99;
opts.rho       = 0.5;
opts.tau       = 10;
opts.delta     = 0.05;
opts.tol       = 1e-8;

tic
[X,Y,iter,out] = lrtc(M,Data,Omega,L,opts);
toc

RSE    = norm(M(:)-X(:))/norm(M(:));
rank_a = rank(Y,L);

fprintf('\nsampling rate: %.2f\n', p);
fprintf('tensor average rank of the underlying tensor: %d\n', r);
fprintf('tensor average rank of the recovered tensor Y: %d\n', rank_a);
fprintf('the relative recovery error of X: %.4e\n', RSE);